import requests


def ob_tstr(obj):
    return "" if obj is None else str(obj).strip()


class ForticClient:
    def __init__(self, token):
        self.token = token
        self.base_url = "https://mxedi.com/api/invoice"

    def get_header(self, interface_path):
        url = self.base_url + interface_path
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.token}'
        }
        headers["url"] = url
        return headers

    def http_post(self, url, data=None, headers=None):
        headers = headers or {}
        data = {k: ob_tstr(v) for k, v in data.items()}
        resp = requests.post(url, data=data, headers=headers, timeout=30)
        return resp.json()

    def initiate_request_post(self, interface_path, data=None):
        headers = self.get_header(interface_path)
        url = headers.pop("url")
        res = self.http_post(url, data, headers)
        return res

    def login(self, vat, username, password, identity, sms_code=""):
        url = "/login"
        data = {
            "nsrsbh": vat,
            "username": username,
            "password": password,
            "sms": sms_code,
        }
        if identity:
            data["sf"] = identity
        return self.initiate_request_post(url, data)

    def check_face_state(self, vat, username):
        url = "/check_face_state"
        data = {
            "nsrsbh": vat,
            "username": username
        }
        return self.initiate_request_post(url, data)

    def get_face_img(self, vat, username):
        url = "/get_face_img"
        data = {
            "nsrsbh": vat,
            "username": username
        }
        return self.initiate_request_post(url, data)

    def post_invoice(self, vat, username, invoice_data):
        url = "/post_invoice"
        data = {
            "nsrsbh": vat,
            "username": username
        }
        data.update(invoice_data)
        return self.initiate_request_post(url, data)

    def get_invoice_pdf(self, vat, username, invoice_number):
        url = "/get_invoice_pdf"
        data = {
            "nsrsbh": vat,
            "username": username,
            "downflag": "5",
            "fphm": invoice_number
        }
        return self.initiate_request_post(url, data)

    def post_refund_invoice(self, vat, username, invoice_data):
        url = "/post_refund_invoice"
        data = {
            "nsrsbh": vat,
            "username": username,
        }
        data.update(invoice_data)
        return self.initiate_request_post(url, data)

    def get_refund_invoice_pdf(self, vat, username, refund_number):
        url = "/get_refund_invoice_pdf"
        data = {
            "nsrsbh": vat,
            "username": username,
            "hzfpxxqrdbh": refund_number
        }
        return self.initiate_request_post(url, data)
