# -*- coding: utf-8 -*-

from odoo import fields, models, api


class ResConfigSettings(models.TransientModel):
    _inherit = 'res.config.settings'

    cn_post_user_id = fields.Many2one(related='company_id.cn_post_user_id', readonly=False)
    fortic_api_keys = fields.Char(
        string='Fortic API Keys',
        compute='_compute_fortic_api_keys',
        inverse='_inverse_fortic_api_keys',
    )

    def _compute_fortic_api_keys(self):
        for setting in self:
            setting.fortic_api_keys = self.env['ir.config_parameter'].sudo().get_param('l10n_cn_edi.fortic_api_keys')

    def _inverse_fortic_api_keys(self):
        self.env['ir.config_parameter'].sudo().set_param('l10n_cn_edi.fortic_api_keys', self.fortic_api_keys)

    @api.model
    def get_values(self):
        res = super(ResConfigSettings, self).get_values()
        res['fortic_api_keys'] = self.env['ir.config_parameter'].sudo().get_param('l10n_cn_edi.fortic_api_keys')
        return res
