# -*- coding: utf-8 -*-

from odoo import fields, models


class ProductCategory(models.Model):
    _inherit = 'product.category'

    property_cn_tax_product_id = fields.Many2one("cn.tax.product", string="China Tax Product Code",
                                                 company_dependent=True)


class ProductTemplate(models.Model):
    _inherit = 'product.template'

    property_cn_tax_product_id = fields.Many2one("cn.tax.product", string="China Tax Product Code",
                                                 company_dependent=True)
    is_cn_tax_discount = fields.Boolean(string="China Tax Discount Product", default=False, copy=False)

    def _get_cn_tax_product_id(self):
        if self.property_cn_tax_product_id:
            return self.property_cn_tax_product_id
        return self.categ_id.property_cn_tax_product_id


class ProductProduct(models.Model):
    _inherit = 'product.product'

    def _get_cn_tax_product_id(self):
        return self.product_tmpl_id._get_cn_tax_product_id()
