from odoo import models, fields, api
from odoo.osv import expression


class CnTaxProduct(models.Model):
    _name = "cn.tax.product"
    _description = "China Tax Product Code"
    _rec_names_search = ["name", "code"]

    name = fields.Char(string="Name", required=True)
    code = fields.Char(string="Code", required=True)
    description = fields.Text(string="Description")
    company_id = fields.Many2one('res.company', string='Company', required=True, default=lambda self: self.env.company)

    _sql_constraints = [
        ('code_unique', 'unique(code, company_id)', 'The product code must be unique!'),
    ]

    def name_get(self):
        return [(p.id, '%s (%s)' % (p.name, p.description)) for p in self]
