# -*- coding: utf-8 -*-
# Part of MX. See LICENSE file for full copyright and licensing details.

from odoo import api, fields, models, _
from odoo.exceptions import ValidationError


class AccountMove(models.Model):
    _inherit = 'account.move'

    # hz_fapiao = fields.Char(string='Hongzi Fapiao Number', size=64, copy=False, tracking=True)
    fapiao = fields.Char(string='Fapiao Number', size=64, copy=False, tracking=True)

    @api.constrains('fapiao')
    def _check_fapiao(self):
        return True


class AccountMoveLine(models.Model):
    _inherit = 'account.move.line'

    cn_tax_line_number = fields.Integer(copy=True)

    def _need_post_cn_tax_invoice(self):
        if not self.tax_ids:
            return False
        elif self.tax_ids[0].amount == 0:
            return False
        return True


